/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityBean;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.List;

public class LocalModemBean
extends PanelBean
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSLMBT";
    private static final String TRACE_MASKF = "XRCSLMBF";
    private static final String TRACE_MASKD = "XRCSLMBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-LMdmBean");
    private boolean callHomeServer;
    private List phoneNumbers;
    private boolean m_bAllowDial;
    private String m_sDialPrefix;
    private transient ItemDescriptor[][] m_idPhoneNumbersTable;
    private transient ColumnDescriptor[] m_cdPhoneNumbersTableStructure;
    private int[] m_iPhoneNumbersTableSelection;

    public LocalModemBean() {
        Trace.trace(TRACE_MASKT, "<> LocalModemBean()");
    }

    public void setAllowDial(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setAllowDial(" + b + ")");
        this.m_bAllowDial = b;
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- setAllowDial()");
    }

    public boolean isAllowDial() {
        return this.m_bAllowDial;
    }

    public void setDialPrefix(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setDialPrefix(" + s + ")");
        this.m_sDialPrefix = s;
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- setDialPrefix()");
    }

    public String getDialPrefix() {
        return this.m_sDialPrefix;
    }

    public void setPhoneNumbersTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            Trace.trace(TRACE_MASKT, "-> setPhoneNumbersTableSelection(" + selected[0] + ")");
        } else {
            Trace.trace(TRACE_MASKT, "-> setPhoneNumbersTableSelection(none)");
        }
        this.m_iPhoneNumbersTableSelection = selected;
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- setPhoneNumbersTableSelection()");
    }

    public int[] getPhoneNumbersTableSelection() {
        return this.m_iPhoneNumbersTableSelection;
    }

    public void setPhoneNumbersTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idPhoneNumbersTable[index] = items;
    }

    public ItemDescriptor[] getPhoneNumbersTableRowAt(int index) {
        return this.m_idPhoneNumbersTable[index];
    }

    public int getPhoneNumbersTableRowCount() {
        return this.m_idPhoneNumbersTable.length;
    }

    public int getPhoneNumbersTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getPhoneNumbersTableRowStructure() {
        return this.m_cdPhoneNumbersTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void setCallHomeServer(boolean value) {
        Trace.trace(TRACE_MASKT, "<> setCallHomeServer(" + value + ")");
        this.callHomeServer = value;
    }

    public List getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List numbers) {
        Trace.trace(TRACE_MASKT, "<> setPhoneNumbers(" + numbers.size() + ")");
        this.phoneNumbers = numbers;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
        try {
            String element = event.getElementName();
            if (element.endsWith("AddButton")) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setSource("LocalModemBean");
                request.setData("Source", "LocalModemPanel");
                request.setData("Command", "OpenAddPanel");
                this.postTaskletRequest(request);
            } else if (element.endsWith("EditButton")) {
                int[] selections = this.getPhoneNumbersTableSelection();
                if (selections.length >= 1) {
                    int selected = selections[0];
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("LocalModemBean");
                    request.setData("Source", "LocalModemPanel");
                    request.setData("Command", "OpenEditPanel");
                    request.setData("PhoneInfo", this.phoneNumbers.get(selected));
                    this.postTaskletRequest(request);
                }
            } else if (element.endsWith("RemoveButton")) {
                int[] selections = this.getPhoneNumbersTableSelection();
                if (selections.length >= 1) {
                    int selected = selections[0];
                    this.phoneNumbers.remove(selected);
                    this.updateDataBeanInfo(false);
                    if (this.phoneNumbers.size() >= 1) {
                        selections[0] = selected > 0 ? selected - 1 : 0;
                    } else {
                        selections = new int[]{};
                    }
                    this.setPhoneNumbersTableSelection(selections);
                }
            } else if (element.endsWith("TestButton")) {
                int[] selections = this.getPhoneNumbersTableSelection();
                if (selections.length >= 1) {
                    int selected = selections[0];
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("LocalModemBean");
                    request.setData("Source", "LocalModemPanel");
                    request.setData("Command", "OpenTestPanel");
                    request.setData("PhoneInfo", this.phoneNumbers.get(selected));
                    this.postTaskletRequest(request);
                }
            } else if (element.endsWith("UpButton")) {
                int selected;
                int[] selections = this.getPhoneNumbersTableSelection();
                if (selections.length >= 1 && (selected = selections[0]) > 0) {
                    PhoneInfo tempInfo = (PhoneInfo)this.phoneNumbers.get(selected - 1);
                    this.phoneNumbers.set(selected - 1, this.phoneNumbers.get(selected));
                    this.phoneNumbers.set(selected, tempInfo);
                    this.updateDataBeanInfo(false);
                    selections[0] = selected - 1;
                    this.setPhoneNumbersTableSelection(selections);
                }
            } else if (element.endsWith("DownButton")) {
                int selected;
                int[] selections = this.getPhoneNumbersTableSelection();
                if (selections.length >= 1 && (selected = selections[0]) < this.phoneNumbers.size() - 1) {
                    PhoneInfo tempInfo = (PhoneInfo)this.phoneNumbers.get(selected + 1);
                    this.phoneNumbers.set(selected + 1, this.phoneNumbers.get(selected));
                    this.phoneNumbers.set(selected, tempInfo);
                    this.updateDataBeanInfo(false);
                    selections[0] = selected + 1;
                    this.setPhoneNumbersTableSelection(selections);
                }
            } else if (element.endsWith("ModemConfigButton")) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setSource("LocalModemBean");
                request.setData("Source", "LocalModemPanel");
                request.setData("Command", "OpenModemConfigPanel");
                this.postTaskletRequest(request);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown element");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        Trace.trace(TRACE_MASKT, "-> parentalAction(" + event + ")");
        try {
            String command = event.getActionCommand();
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else if (command.endsWith("ParentalValidate")) {
                if (this.callHomeServer && this.m_bAllowDial) {
                    ((OutboundConnectivityBean)parent).setConnectivityEnabled();
                    if (this.phoneNumbers.size() < 1) {
                        Integer minNumbers = new Integer(1);
                        Integer numToAdd = new Integer(1 - this.phoneNumbers.size());
                        String msgId = "MIN_PHONE_NUMBERS";
                        LocalizableText title = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", msgId + ".TITLE");
                        Object[] subst = new Object[]{minNumbers, numToAdd};
                        MessageText text = new MessageText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", msgId + ".MSG", subst);
                        Object[] msgInfo = new Object[]{title, text};
                        ((OutboundConnectivityBean)parent).setValidateErrorMsgInfo(msgInfo);
                    }
                }
            } else if (command.endsWith("ParentalCommit")) {
                try {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("LocalModemBean");
                    request.setData("Source", "LocalModemPanel");
                    request.setData("Command", "Commit");
                    request.setData("Bean", this);
                    this.postTaskletRequest(request);
                }
                catch (IllegalUserDataException iude) {}
            } else if (command.endsWith("ParentalUpdate")) {
                OutboundConnectivityBean outConnBean = (OutboundConnectivityBean)parent;
                this.callHomeServer = outConnBean.isCallHomeServer();
                this.updateUTMElements();
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- parentalAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "-> update()");
        try {
            HashMap data = (HashMap)newData;
            String command = (String)data.get("Command");
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else if (command.equals("AddPhoneNumber")) {
                PhoneInfo newPhoneInfo = (PhoneInfo)data.get("PhoneInfo");
                if (newPhoneInfo != null) {
                    Trace.trace(TRACE_MASKF, "newNumber=" + newPhoneInfo);
                    this.phoneNumbers.add(newPhoneInfo);
                    this.updateDataBeanInfo(false);
                    this.setPhoneNumbersTableSelection(new int[]{this.phoneNumbers.size() - 1});
                }
            } else if (command.equals("UpdatePhoneNumber")) {
                PhoneInfo newPhoneInfo = (PhoneInfo)data.get("PhoneInfo");
                if (newPhoneInfo != null) {
                    Trace.trace(TRACE_MASKF, "updatedNumber=" + newPhoneInfo);
                    int[] selections = this.getPhoneNumbersTableSelection();
                    if (selections.length >= 1) {
                        int selected = selections[0];
                        this.phoneNumbers.set(selected, newPhoneInfo);
                    }
                    this.updateDataBeanInfo(false);
                    this.updateUTMElements();
                }
            } else if (command.equals("UpdateDialPrefix")) {
                String newDialPrefix = (String)data.get("DialPrefix");
                if (newDialPrefix != null) {
                    this.setDialPrefix(newDialPrefix);
                }
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- update()");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        this.m_idPhoneNumbersTable = new ItemDescriptor[this.phoneNumbers.size()][2];
        for (int i = 0; i < this.phoneNumbers.size(); ++i) {
            PhoneInfo phoneNumber = (PhoneInfo)this.phoneNumbers.get(i);
            String number = phoneNumber.getPhoneNumber();
            this.m_idPhoneNumbersTable[i][0] = new ItemDescriptor(null, number);
            String comment = phoneNumber.getDescription();
            this.m_idPhoneNumbersTable[i][1] = new ItemDescriptor(null, comment);
        }
        if (initialUpdate) {
            if (this.m_sDialPrefix == null) {
                this.m_sDialPrefix = "";
            }
            this.m_cdPhoneNumbersTableStructure = new ColumnDescriptor[0];
            this.m_iPhoneNumbersTableSelection = this.phoneNumbers.size() >= 1 ? new int[]{0} : new int[0];
        }
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace(TRACE_MASKT, "-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            if (this.m_bAllowDial) {
                this.userTaskManager.setSelected(prefix + "AllowDialCheckbox", true);
                if (this.callHomeServer) {
                    this.userTaskManager.setEnabled(prefix + "AllowDialCheckbox", true);
                    this.userTaskManager.setEnabled(prefix + "ModemGroup", true);
                    this.userTaskManager.setEnabled(prefix + "ModemConfigButton", true);
                    this.userTaskManager.setEnabled(prefix + "PhoneNumbersGroup", true);
                    this.userTaskManager.setEnabled(prefix + "PhoneNumbersTable", true);
                    if (this.phoneNumbers.size() < 5) {
                        this.userTaskManager.setEnabled(prefix + "AddButton", true);
                    } else {
                        this.userTaskManager.setEnabled(prefix + "AddButton", false);
                    }
                } else {
                    this.userTaskManager.setEnabled(prefix + "AllowDialCheckbox", false);
                    this.userTaskManager.setEnabled(prefix + "ModemGroup", false);
                    this.userTaskManager.setEnabled(prefix + "ModemConfigButton", false);
                    this.userTaskManager.setEnabled(prefix + "PhoneNumbersGroup", false);
                    this.userTaskManager.setEnabled(prefix + "PhoneNumbersTable", false);
                    this.userTaskManager.setEnabled(prefix + "AddButton", false);
                }
            } else {
                this.userTaskManager.setSelected(prefix + "AllowDialCheckbox", false);
                if (this.callHomeServer) {
                    this.userTaskManager.setEnabled(prefix + "AllowDialCheckbox", true);
                } else {
                    this.userTaskManager.setEnabled(prefix + "AllowDialCheckbox", false);
                }
                this.userTaskManager.setEnabled(prefix + "ModemGroup", false);
                this.userTaskManager.setEnabled(prefix + "ModemConfigButton", false);
                this.userTaskManager.setEnabled(prefix + "PhoneNumbersGroup", false);
                this.userTaskManager.setEnabled(prefix + "PhoneNumbersTable", false);
                this.userTaskManager.setEnabled(prefix + "AddButton", false);
            }
            if (this.m_iPhoneNumbersTableSelection.length >= 1 && this.m_bAllowDial && this.callHomeServer) {
                this.userTaskManager.setEnabled(prefix + "EditButton", true);
                this.userTaskManager.setEnabled(prefix + "RemoveButton", true);
                this.userTaskManager.setEnabled(prefix + "TestButton", true);
                this.userTaskManager.setEnabled(prefix + "UpButton", true);
                this.userTaskManager.setEnabled(prefix + "DownButton", true);
            } else {
                this.userTaskManager.setEnabled(prefix + "EditButton", false);
                this.userTaskManager.setEnabled(prefix + "RemoveButton", false);
                this.userTaskManager.setEnabled(prefix + "TestButton", false);
                this.userTaskManager.setEnabled(prefix + "UpButton", false);
                this.userTaskManager.setEnabled(prefix + "DownButton", false);
            }
            this.userTaskManager.refreshElement(prefix + "AllowDialCheckbox");
            this.userTaskManager.refreshElement(prefix + "ModemGroup");
            this.userTaskManager.refreshElement(prefix + "ModemConfigButton");
            this.userTaskManager.refreshElement(prefix + "PhoneNumbersGroup");
            this.userTaskManager.refreshElement(prefix + "PhoneNumbersTable");
            this.userTaskManager.refreshElement(prefix + "AddButton");
            this.userTaskManager.refreshElement(prefix + "EditButton");
            this.userTaskManager.refreshElement(prefix + "RemoveButton");
            this.userTaskManager.refreshElement(prefix + "TestButton");
            this.userTaskManager.refreshElement(prefix + "UpButton");
            this.userTaskManager.refreshElement(prefix + "DownButton");
        }
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }
}

